/*
 * Decompiled with CFR 0.152.
 */
package org.junitee.anttask;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.taskdefs.optional.junit.DOMUtil;
import org.apache.tools.ant.util.DOMElementWriter;
import org.junitee.anttask.AbstractResultFormatter;
import org.junitee.anttask.JUnitEEResultFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLResultFormatter
extends AbstractResultFormatter
implements JUnitEEResultFormatter {
    public void format(Node testSuiteNode) throws IOException {
        Document doc = this.getDocumentBuilder().newDocument();
        Element rootElement = doc.createElement("testsuite");
        NamedNodeMap attributes = testSuiteNode.getAttributes();
        String time = attributes.getNamedItem("time").getNodeValue();
        String tests = attributes.getNamedItem("tests").getNodeValue();
        String errors = attributes.getNamedItem("errors").getNodeValue();
        String failures = attributes.getNamedItem("failures").getNodeValue();
        String testName = this.getTestName(testSuiteNode);
        rootElement.setAttribute("name", testName);
        rootElement.setAttribute("errors", errors);
        rootElement.setAttribute("failures", failures);
        rootElement.setAttribute("tests", tests);
        rootElement.setAttribute("time", time);
        for (Node testcase = testSuiteNode.getFirstChild(); testcase != null; testcase = testcase.getNextSibling()) {
            DOMUtil.importNode((Node)rootElement, (Node)testcase);
        }
        if (this.getOutput(testName) != null) {
            OutputStreamWriter writer = null;
            writer = new OutputStreamWriter(this.getOutput(testName), "UTF8");
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            new DOMElementWriter().write(rootElement, (Writer)writer, 0, "  ");
            ((Writer)writer).flush();
        }
    }

    private DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }
}

